/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.type.AbstractType;
import io.prestosql.spi.type.FixedWidthType;
import io.prestosql.spi.type.LongTimeWithTimeZoneType;
import io.prestosql.spi.type.ShortTimeWithTimeZoneType;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;

public abstract class TimeWithTimeZoneType
extends AbstractType
implements FixedWidthType {
    public static final int MAX_PRECISION = 12;
    public static final int MAX_SHORT_PRECISION = 9;
    public static final int DEFAULT_PRECISION = 3;
    @Deprecated
    public static final TimeWithTimeZoneType TIME_WITH_TIME_ZONE = new ShortTimeWithTimeZoneType(3);
    private final int precision;

    public static TimeWithTimeZoneType createTimeWithTimeZoneType(int precision) {
        if (precision == 3) {
            return TIME_WITH_TIME_ZONE;
        }
        if (precision < 0 || precision > 12) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("TIME WITH TIME ZONE precision must be in range [0, %s]: %s", 12, precision));
        }
        if (precision <= 9) {
            return new ShortTimeWithTimeZoneType(precision);
        }
        return new LongTimeWithTimeZoneType(precision);
    }

    protected TimeWithTimeZoneType(int precision, Class<?> javaType) {
        super(new TypeSignature("time with time zone", TypeSignatureParameter.numericParameter(precision)), javaType);
        this.precision = precision;
    }

    public int getPrecision() {
        return this.precision;
    }

    @Override
    public final boolean isComparable() {
        return true;
    }

    @Override
    public final boolean isOrderable() {
        return true;
    }
}

