/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import io.prestosql.spi.type.ParametricType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeParameter;
import java.util.List;

public class TimestampWithTimeZoneParametricType
implements ParametricType {
    public static final TimestampWithTimeZoneParametricType TIMESTAMP_WITH_TIME_ZONE = new TimestampWithTimeZoneParametricType();

    @Override
    public String getName() {
        return "timestamp with time zone";
    }

    @Override
    public Type createType(TypeManager typeManager, List<TypeParameter> parameters) {
        if (parameters.isEmpty()) {
            return TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE;
        }
        if (parameters.size() != 1) {
            throw new IllegalArgumentException("Expected exactly one parameter for TIMESTAMP WITH TIME ZONE");
        }
        TypeParameter parameter = parameters.get(0);
        if (!parameter.isLongLiteral()) {
            throw new IllegalArgumentException("TIMESTAMP precision must be a number");
        }
        long precision = parameter.getLongLiteral();
        if (precision < 0L || precision > 12L) {
            throw new IllegalArgumentException("Invalid TIMESTAMP precision " + precision);
        }
        return TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)precision);
    }
}

